/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.network;

import com.nyfaria.numismaticoverhaul.cap.CurrencyHolderAttacher;
import com.nyfaria.numismaticoverhaul.currency.CurrencyConverter;
import com.nyfaria.numismaticoverhaul.currency.CurrencyHelper;
import dev._100media.capabilitysyncer.network.IPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public record RequestPurseActionC2SPacket(Action action, long value) implements IPacket
{
    public RequestPurseActionC2SPacket(FriendlyByteBuf packetBuf) {
        this((Action)packetBuf.m_130066_(Action.class), packetBuf.readLong());
    }

    public void handle(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player.f_36096_ instanceof InventoryMenu || RequestPurseActionC2SPacket.isInventorioHandler(player)) {
            switch (this.action) {
                case STORE_ALL: {
                    CurrencyHolderAttacher.getExampleHolderUnwrap((Entity)player).modify(CurrencyHelper.getMoneyInInventory((Player)player, true));
                    break;
                }
                case EXTRACT: {
                    if (CurrencyHolderAttacher.getExampleHolderUnwrap((Entity)player).getValue() < this.value) {
                        return;
                    }
                    CurrencyConverter.getAsItemStackList(this.value).forEach(stack -> player.m_150109_().m_150079_(stack));
                    CurrencyHolderAttacher.getExampleHolderUnwrap((Entity)player).modify(-this.value);
                    break;
                }
                case EXTRACT_ALL: {
                    CurrencyConverter.getAsValidStacks(CurrencyHolderAttacher.getExampleHolderUnwrap((Entity)player).getValue()).forEach(stack -> player.m_150109_().m_150079_(stack));
                    CurrencyHolderAttacher.getExampleHolderUnwrap((Entity)player).modify(-CurrencyHolderAttacher.getExampleHolderUnwrap((Entity)player).getValue());
                }
            }
        }
    }

    public void write(FriendlyByteBuf packetBuf) {
        packetBuf.m_130068_((Enum)this.action);
        packetBuf.writeLong(this.value);
    }

    private static boolean isInventorioHandler(ServerPlayer player) {
        return false;
    }

    public static RequestPurseActionC2SPacket storeAll() {
        return new RequestPurseActionC2SPacket(Action.STORE_ALL, 0L);
    }

    public static RequestPurseActionC2SPacket extractAll() {
        return new RequestPurseActionC2SPacket(Action.EXTRACT_ALL, 0L);
    }

    public static RequestPurseActionC2SPacket extract(long amount) {
        return new RequestPurseActionC2SPacket(Action.EXTRACT, amount);
    }

    public static void register(SimpleChannel channel, int id) {
        IPacket.register((SimpleChannel)channel, (int)id, (NetworkDirection)NetworkDirection.PLAY_TO_SERVER, RequestPurseActionC2SPacket.class, RequestPurseActionC2SPacket::new);
    }

    public static enum Action {
        STORE_ALL,
        EXTRACT,
        EXTRACT_ALL;

    }
}

